/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomNpcs;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.data.INPCMelee;
import noppes.npcs.api.entity.data.INPCRanged;
import noppes.npcs.api.entity.data.INPCStats;
import noppes.npcs.constants.EnumCreatureRarity;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataMelee;
import noppes.npcs.entity.data.DataRanged;
import noppes.npcs.entity.data.Resistances;
import noppes.npcs.util.ValueUtil;

public class DataStats
implements INPCStats {
    public boolean burnInSun = false;
    public boolean calmdown = true;
    public boolean canDrown = true;
    public boolean hideKilledBody = false;
    public boolean ignoreCobweb = false;
    public boolean immuneToFire = false;
    public boolean noFallDamage = false;
    public boolean potionImmune = false;
    public int aggroRange = 16;
    public int combatRegen = 0;
    public int healthRegen = 1;
    private int level = 1;
    public int respawnTime = 20;
    public int spawnCycle = 0;
    private float chanceBlockDamage = 2.0f;
    public double maxHealth = 20.0;
    public EnumCreatureAttribute creatureType = EnumCreatureAttribute.UNDEFINED;
    private String rarityTitle = "\u00a7flv.\u00a721";
    private EnumCreatureRarity rarity = EnumCreatureRarity.NORMAL;
    public DataMelee melee;
    private final EntityNPCInterface npc;
    public DataRanged ranged;
    public Resistances resistances = new Resistances();

    public DataStats(EntityNPCInterface npc) {
        this.npc = npc;
        this.melee = new DataMelee(npc);
        this.ranged = new DataRanged(npc);
    }

    @Override
    public int getAggroRange() {
        return this.aggroRange;
    }

    @Override
    public int getCombatRegen() {
        return this.combatRegen;
    }

    @Override
    public int getCreatureType() {
        return this.creatureType.ordinal();
    }

    @Override
    public int getHealthRegen() {
        return this.healthRegen;
    }

    @Override
    public boolean getHideDeadBody() {
        return this.hideKilledBody;
    }

    public double getHP() {
        int[] corr = CustomNpcs.HealthNormal;
        if (this.rarity == EnumCreatureRarity.ELITE) {
            corr = CustomNpcs.HealthElite;
        } else if (this.rarity == EnumCreatureRarity.BOSS) {
            corr = CustomNpcs.HealthBoss;
        }
        double a = ((double)corr[0] - (double)corr[1]) / (1.0 - Math.pow(CustomNpcs.MaxLv, 2.0));
        double b = (double)corr[0] - a;
        double hp = Math.round(a * Math.pow(this.level, 2.0) + b);
        if (hp <= 1.0) {
            hp = 1.0;
        }
        if ((hp = hp > 10000.0 ? Math.ceil(hp / 100.0) * 100.0 : (hp > 1000.0 ? Math.ceil(hp / 25.0) * 25.0 : (hp > 100.0 ? Math.ceil(hp / 10.0) * 10.0 : (hp > 50.0 ? Math.ceil(hp / 5.0) * 5.0 : Math.ceil(hp))))) > (double)corr[1]) {
            hp = corr[1];
        }
        return hp;
    }

    @Override
    public boolean getImmune(int type) {
        switch (type) {
            case 0: {
                return this.potionImmune;
            }
            case 1: {
                return this.noFallDamage;
            }
            case 2: {
                return this.burnInSun;
            }
            case 3: {
                return this.immuneToFire;
            }
            case 4: {
                return this.canDrown;
            }
            case 5: {
                return this.ignoreCobweb;
            }
        }
        throw new CustomNPCsException("Unknown immune type: " + type, new Object[0]);
    }

    @Override
    public int getLevel() {
        if (this.level < 1) {
            this.level = 1;
        } else if (this.level > CustomNpcs.MaxLv) {
            this.level = CustomNpcs.MaxLv;
        }
        return this.level;
    }

    @Override
    public double getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public INPCMelee getMelee() {
        return this.melee;
    }

    @Override
    public INPCRanged getRanged() {
        return this.ranged;
    }

    @Override
    public int getRarity() {
        return this.rarity.ordinal();
    }

    @Override
    public String getRarityTitle() {
        return this.rarityTitle;
    }

    @Override
    public String[] getResistanceKeys() {
        return this.resistances.data.keySet().toArray(new String[0]);
    }

    @Override
    public float getResistance(String damageName) {
        return this.resistances.get(damageName);
    }

    @Override
    public int getRespawnTime() {
        return this.respawnTime;
    }

    @Override
    public int getRespawnType() {
        return this.spawnCycle;
    }

    @Override
    public boolean isCalmdown() {
        return this.calmdown;
    }

    public void readToNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("Resistances", 9)) {
            this.resistances.readToNBT(compound.func_150295_c("Resistances", 10));
        } else {
            this.resistances.oldReadToNBT(compound.func_74775_l("Resistances"));
        }
        if (compound.func_150297_b("MaxHealth", 3)) {
            this.setMaxHealth(compound.func_74762_e("MaxHealth"));
        } else {
            this.setMaxHealth(compound.func_74769_h("MaxHealth"));
        }
        this.hideKilledBody = compound.func_74767_n("HideBodyWhenKilled");
        this.aggroRange = compound.func_74762_e("AggroRange");
        this.respawnTime = compound.func_74762_e("RespawnTime");
        this.spawnCycle = compound.func_74762_e("SpawnCycle");
        this.creatureType = EnumCreatureAttribute.values()[compound.func_74762_e("CreatureType")];
        this.healthRegen = compound.func_74762_e("HealthRegen");
        this.combatRegen = compound.func_74762_e("CombatRegen");
        this.immuneToFire = compound.func_74767_n("ImmuneToFire");
        this.potionImmune = compound.func_74767_n("PotionImmune");
        this.canDrown = compound.func_74767_n("CanDrown");
        this.burnInSun = compound.func_74767_n("BurnInSun");
        this.noFallDamage = compound.func_74767_n("NoFallDamage");
        this.npc.setImmuneToFire(this.immuneToFire);
        this.ignoreCobweb = compound.func_74767_n("IgnoreCobweb");
        this.melee.readFromNBT(compound);
        this.ranged.readFromNBT(compound);
        this.level = compound.func_74762_e("NPCLevel");
        this.rarity = EnumCreatureRarity.values()[compound.func_74762_e("NPCRarity")];
        this.rarityTitle = compound.func_74779_i("RarityTitle");
        this.calmdown = compound.func_74767_n("CalmdownRange");
        if (this.aggroRange < 1) {
            this.aggroRange = 1;
        }
        IAttributeInstance follow_range = this.npc.func_110148_a(SharedMonsterAttributes.field_111265_b);
        follow_range.func_111128_a((double)this.aggroRange);
        if (compound.func_150297_b("ChanceBlockDamage", 5)) {
            this.setChanceBlockDamage(compound.func_74760_g("ChanceBlockDamage"));
        }
    }

    @Override
    public void setAggroRange(int range) {
        this.aggroRange = range;
    }

    @Override
    public void setCalmdown(boolean range) {
        this.calmdown = range;
    }

    @Override
    public void setCombatRegen(int regen) {
        this.combatRegen = regen;
    }

    @Override
    public void setCreatureType(int type) {
        this.creatureType = EnumCreatureAttribute.values()[type];
    }

    @Override
    public void setHealthRegen(int regen) {
        this.healthRegen = regen;
    }

    @Override
    public void setHideDeadBody(boolean hide) {
        this.hideKilledBody = hide;
        this.npc.updateClient = true;
    }

    @Override
    public void setImmune(int type, boolean bo) {
        if (type == 0) {
            this.potionImmune = bo;
        } else if (type == 1) {
            this.noFallDamage = !bo;
        } else if (type == 2) {
            this.burnInSun = bo;
        } else if (type == 3) {
            this.npc.setImmuneToFire(bo);
        } else if (type == 4) {
            this.canDrown = !bo;
        } else {
            if (type != 5) {
                throw new CustomNPCsException("Unknown immune type: " + type, new Object[0]);
            }
            this.ignoreCobweb = bo;
        }
    }

    @Override
    public void setLevel(int level) {
        if (level < 1) {
            level = 1;
        } else if (level > CustomNpcs.MaxLv) {
            level = CustomNpcs.MaxLv;
        }
        this.level = level;
    }

    @Override
    public void setMaxHealth(double maxHealth) {
        if (maxHealth == this.maxHealth) {
            return;
        }
        this.maxHealth = maxHealth;
        this.npc.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(maxHealth);
        this.npc.updateClient = true;
    }

    @Override
    public void setRarity(int rarity) {
        if (rarity < 0) {
            rarity = 0;
        } else if (rarity > EnumCreatureRarity.values().length) {
            rarity = EnumCreatureRarity.values().length;
        }
        this.rarity = EnumCreatureRarity.values()[rarity];
    }

    @Override
    public void setRarityTitle(String rarity) {
        if (this.rarityTitle.equals(rarity)) {
            return;
        }
        this.rarityTitle = rarity;
        this.npc.updateClient = true;
    }

    @Override
    public void setResistance(String damageName, float value) {
        this.resistances.data.put(damageName, Float.valueOf(ValueUtil.correctFloat(value, 0.0f, 2.0f)));
    }

    @Override
    public void setRespawnTime(int seconds) {
        this.respawnTime = seconds;
    }

    @Override
    public void setRespawnType(int type) {
        this.spawnCycle = type;
    }

    @Override
    public float getChanceBlockDamage() {
        return this.chanceBlockDamage;
    }

    @Override
    public void setChanceBlockDamage(float chance) {
        if (chance < 0.0f) {
            chance *= -1.0f;
        }
        if (chance > 100.0f) {
            chance = 100.0f;
        }
        this.chanceBlockDamage = chance;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Resistances", (NBTBase)this.resistances.writeToNBT());
        compound.func_74780_a("MaxHealth", this.maxHealth);
        compound.func_74768_a("AggroRange", this.aggroRange);
        compound.func_74757_a("HideBodyWhenKilled", this.hideKilledBody);
        compound.func_74768_a("RespawnTime", this.respawnTime);
        compound.func_74768_a("SpawnCycle", this.spawnCycle);
        compound.func_74768_a("CreatureType", this.creatureType.ordinal());
        compound.func_74768_a("HealthRegen", this.healthRegen);
        compound.func_74768_a("CombatRegen", this.combatRegen);
        compound.func_74757_a("ImmuneToFire", this.immuneToFire);
        compound.func_74757_a("PotionImmune", this.potionImmune);
        compound.func_74757_a("CanDrown", this.canDrown);
        compound.func_74757_a("BurnInSun", this.burnInSun);
        compound.func_74757_a("NoFallDamage", this.noFallDamage);
        compound.func_74757_a("IgnoreCobweb", this.ignoreCobweb);
        this.melee.writeToNBT(compound);
        this.ranged.writeToNBT(compound);
        compound.func_74768_a("NPCLevel", this.level);
        compound.func_74768_a("NPCRarity", this.rarity.ordinal());
        compound.func_74778_a("RarityTitle", this.rarityTitle);
        compound.func_74757_a("CalmdownRange", this.calmdown);
        compound.func_74776_a("ChanceBlockDamage", this.chanceBlockDamage);
        return compound;
    }
}

